:
# NAME:
#	realpath - for systems that lack it
#
# DESCRIPTION:
#	If there is no 'realpath' binary, provide a function that
#	that achieves (generally) the same result.
#
#
# AUTHOR:
#	Simon J. Gerraty <sjg@crufty.net>

# RCSid:
#	$Id: realpath.sh,v 1.9 2025/08/07 21:59:54 sjg Exp $
#
#	@(#) Copyright (c) 2012-2024 Simon J. Gerraty
#
#	SPDX-License-Identifier: BSD-2-Clause
#      
#	Please send copies of changes and bug-fixes to:
#	sjg@crufty.net
#

_REALPATH_SH=:

_trp=`(type realpath) 2> /dev/null |
	sed '/not.*found/d;/function/d;s,.* /,/,'`

case "/$0" in
*/realpath*)
    case "$1" in
    --force) shift; _trp=;;
    esac
    ;;
esac

# from test_opt.sh
_TEST_OPT_SH=:
##
# test_opt opt alternative target prefix
#
# shell's typically have test(1) as built-in
# and not all support all options.
# 
# This function can actually test options for other built-ins
# eg. test_opt P '' . cd
# will set cd_P=-P if cd supports that
#
# test_opt L -h
# will set test_L to -L or -h if -L isn't supported
# 
test_opt() {
    _o=$1
    _a=$2
    _t=${3:-/}
    _p=${4:-test}

    case `($_p -$_o $_t) 2>&1` in
    *:*) eval ${_p}_$_o=$_a;;
    *) eval ${_p}_$_o=-$_o;;
    esac
}

test_opt L -h

read_link() {
    if test $test_L $1; then
        'ls' -l $1 | sed 's,.*> ,,'
    else
        echo $1
    fi
}

if test -z "$isPOSIX_SHELL"; then
    # from isposix-shell.sh
    _isPOSIX_SHELL_SH=:
    if (echo ${PATH%:*}) > /dev/null 2>&1; then
        # true should be a builtin, : certainly is
        isPOSIX_SHELL=:
        # you need to eval $local var
        local=local
        : KSH_VERSION=$KSH_VERSION
        case "$KSH_VERSION" in
        Version*) local=: ;; # broken
        esac
        # reduce the cost of these
        basename() {
            local b=${1%$2}
            echo ${b##*/}
        }
        dirname() {
            case "$1" in
            *?/*) echo ${1%/*};;
            /*) echo /;;
            *) echo .;;
            esac
        }
    else
        isPOSIX_SHELL=false
        local=:
        false() { return 1; }
    fi
fi

if test -z "$_trp"; then
    # if cd supports -P we need it
    test_opt P "" . cd
    
resolve_link() {
    case "$1" in
    */*) d=`dirname $1`;;
    *) d=`${pwd:-'pwd'}`;;
    esac
    x=`read_link $1`
    case "$x" in
    /*) echo $x;;
    *) echo $d/$x;;
    esac
}

realpath1() {
    # deal with the trivial case first
    if test -d "$1"; then
        ('cd' $cd_P "$1" && ${pwd:-'pwd'})
        return 0
    fi
    f=`resolve_link $1`
    while test -s $f -a $test_L $f
    do
        f=`resolve_link $f`
    done
    case "$f" in
    */*)
        d=`dirname $f`
        b=`basename $f`
        while :
        do
            if test -d $d; then
                d=`'cd' $cd_P $d/. && ${pwd:-'pwd'}`
                break
            fi
            case "$d" in
            */*)
                b=`basename $d`/$b
                d=`dirname $d`
                continue
                ;;
            esac
            echo $1
            return
        done
        ;;
    *) d=`${pwd:-'pwd'}`; b=$1;;
    esac
    echo $d/$b
}

realpath() {
    for p in "$@"
    do
        realpath1 "$p"
    done
}
fi

case "/$0" in
*/realpath*) realpath "$@";;
esac
