#!/usr/bin/env python


"""
RCSid:
	$Id: Signer.py,v 1.19 2025/04/19 18:27:55 sjg Exp $

	@(#) Copyright (c) 2012 Simon J. Gerraty

	This file is provided in the hope that it will
	be of use.  There is absolutely NO WARRANTY.
	Permission to copy, redistribute or otherwise
	use this file is hereby granted provided that 
	the above copyright notice and this notice are
	left intact. 
      
	Please send copies of changes and bug-fixes to:
	sjg@crufty.net

"""

import conf as cf
from pem import *

class Signer(object):
    """base signer"""
    def __init__(self, kfile, conf={}):
        """save setup"""
        self.conf = conf
        self.kfile = kfile
        self.key = None
        self.signer = None
        self.sig_encoding = conf.get('SigEncoding', 'PEM')

    def begin(self, request, client_address):
        """here is where you do any initial negotiation with client"""
        return

    def end(self, request, client_address):
        """closing the loop"""
        return

    def sign(self, msg):
        """sign msg"""
        raise TypeError('Not implemented')

    def verify(self, msg, sig):
        """verify sig for msg"""
        raise TypeError('Not implemented')

    def encode_sig(self, sig, tag=None):
        """encode sig for return to client using PEM by default"""
        if self.sig_encoding == "PEM":
            return b(pem_encode(tag, sig))
        else:
            return b(sig);

