/*
 * RCSid:
 *	$Id: signer.i,v 1.4 2013/07/18 20:41:11 sjg Exp $
 *
 *	@(#) Copyright (c) 2012 Simon J. Gerraty
 *
 *	This file is provided in the hope that it will
 *	be of use.  There is absolutely NO WARRANTY.
 *	Permission to copy, redistribute or otherwise
 *	use this file is hereby granted provided that 
 *	the above copyright notice and this notice are
 *	left intact. 
 *      
 *	Please send copies of changes and bug-fixes to:
 *	sjg@crufty.net
 */
%module signer
%include "cstring.i"
%{
#include <openssl/evp.h>

int use_engine(const char *engine);

EVP_PKEY * load_key(const char *file);
EVP_PKEY * load_pubkey(const char *file);


void sign_digest(EVP_PKEY *pkey, const char *digest,
		 void *mdata, size_t mlen,
		 void **bp, size_t *bsz);

void verify_digest(EVP_PKEY *pkey, const char *digest,
		   void *mdata, size_t mlen,
		   void *sdata, size_t slen);

%}

int use_engine(const char *engine);

EVP_PKEY * load_key(const char *file);

EVP_PKEY * load_pubkey(const char *file);

%typemap(in)  (void *data, size_t dlen) {
	$1 = PyString_AsString($input);
	$2 = PyString_Size($input);
};

%typemap(in)  (void *sdata, size_t slen) {
	$1 = PyString_AsString($input);
	$2 = PyString_Size($input);
};

%cstring_output_allocate_size(void **bp, size_t *bsz, free(*$1));

void  sign_digest(EVP_PKEY *pkey, const char *digest,
		  void *data, size_t dlen,
		  void **bp, size_t *bsz);

void verify_digest(EVP_PKEY *pkey, const char *digest,
		   void *data, size_t dlen,
		   void *sdata, size_t slen);
